/*
 * This file is part of architectury.
 * Copyright (C) 2020, 2021, 2022 architectury
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

package dev.architectury.registry.menu.fabric;

import dev.architectury.registry.menu.ExtendedMenuProvider;
import dev.architectury.registry.menu.MenuRegistry.ExtendedMenuTypeFactory;
import dev.architectury.registry.menu.MenuRegistry.SimpleMenuTypeFactory;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerType;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3917;
import net.minecraft.class_7701;
import net.minecraft.class_9135;
import org.jetbrains.annotations.Nullable;

import java.util.function.Function;

public class MenuRegistryImpl {
    public static void openExtendedMenu(class_3222 player, ExtendedMenuProvider provider) {
        player.method_17355(new ExtendedScreenHandlerFactory<byte[]>() {
            @Override
            public byte[] getScreenOpeningData(class_3222 player) {
                class_2540 buf = PacketByteBufs.create();
                provider.saveExtraData(buf);
                byte[] bytes = ByteBufUtil.getBytes(buf);
                buf.release();
                return bytes;
            }
            
            @Override
            public class_2561 method_5476() {
                return provider.method_5476();
            }
            
            @Nullable
            @Override
            public class_1703 createMenu(int i, class_1661 inventory, class_1657 player) {
                return provider.createMenu(i, inventory, player);
            }
        });
    }
    
    public static <T extends class_1703> class_3917<T> of(SimpleMenuTypeFactory<T> factory) {
        return new class_3917<>(factory::create, class_7701.field_40182);
    }
    
    public static <T extends class_1703> class_3917<T> ofExtended(ExtendedMenuTypeFactory<T> factory) {
        return new ExtendedScreenHandlerType<>((syncId, inventory, data) -> {
            class_2540 buf = new class_2540(Unpooled.wrappedBuffer(data));
            T menu = factory.create(syncId, inventory, buf);
            buf.release();
            return menu;
        }, class_9135.field_48987.method_56439(Function.identity()));
    }
}
