/*
 * This file is part of architectury.
 * Copyright (C) 2020, 2021, 2022 architectury
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

package dev.architectury.registry.client.gui;

import dev.architectury.injectables.annotations.ExpectPlatform;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_2561;
import net.minecraft.class_3917;
import net.minecraft.class_3936;
import net.minecraft.class_437;

public class MenuScreenRegistry {
    /**
     * Registers a Screen Factory on the client to display.
     *
     * @param type    The {@link class_3917} the screen visualizes
     * @param factory A functional interface that is used to create new {@link class_437}s
     * @param <H>     The type of {@link class_1703} for the screen
     * @param <S>     The type for the {@link class_437}
     */
    @ExpectPlatform
    public static <H extends class_1703, S extends class_437 & class_3936<H>> void registerScreenFactory(class_3917<? extends H> type, ScreenFactory<H, S> factory) {
        throw new AssertionError();
    }
    
    /**
     * Creates new screens.
     *
     * @param <H> The type of {@link class_1703} for the screen
     * @param <S> The type for the {@link class_437}
     */
    @FunctionalInterface
    public interface ScreenFactory<H extends class_1703, S extends class_437 & class_3936<H>> {
        /**
         * Creates a new {@link S} that extends {@link class_437}
         *
         * @param containerMenu The {@link class_1703} that controls the game logic for the screen
         * @param inventory     The {@link class_1661} for the screen
         * @param component     The {@link class_2561} for the screen
         * @return A new {@link S} that extends {@link class_437}
         */
        S create(H containerMenu, class_1661 inventory, class_2561 component);
    }
}
