/*
 * This file is part of architectury.
 * Copyright (C) 2020, 2021, 2022 architectury
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

package dev.architectury.networking;

import dev.architectury.extensions.network.EntitySpawnExtension;
import io.netty.buffer.Unpooled;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3730;
import net.minecraft.class_9129;

public class ClientSpawnEntityPacket {
    public static void register() {
        NetworkManager.registerReceiver(NetworkManager.s2c(), SpawnEntityPacket.PACKET_TYPE, SpawnEntityPacket.PACKET_CODEC, ClientSpawnEntityPacket::receive);
    }
    
    private static void receive(SpawnEntityPacket.PacketPayload payload, NetworkManager.PacketContext context) {
        context.queue(() -> {
            if (class_310.method_1551().field_1687 == null) {
                throw new IllegalStateException("Client world is null!");
            }
            var entity = payload.entityType().method_5883(class_310.method_1551().field_1687, class_3730.field_52444);
            if (entity == null) {
                throw new IllegalStateException("Created entity is null!");
            }
            entity.method_5826(payload.uuid());
            entity.method_5838(payload.id());
            entity.method_43391(payload.x(), payload.y(), payload.z());
            entity.method_5808(payload.x(), payload.y(), payload.z(), payload.xRot(), payload.yRot());
            entity.method_5847(payload.yHeadRot());
            entity.method_5636(payload.yHeadRot());
            if (entity instanceof EntitySpawnExtension ext) {
                class_9129 buf = new class_9129(Unpooled.wrappedBuffer(payload.data()), context.registryAccess());
                ext.loadAdditionalSpawnData(buf);
                buf.release();
            }
            class_310.method_1551().field_1687.method_53875(entity);
            entity.method_5750(new class_243(payload.deltaX(), payload.deltaY(), payload.deltaZ()));
        });
    }
}
