/*
 * This file is part of architectury.
 * Copyright (C) 2020, 2021, 2022 architectury
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

package dev.architectury.mixin.fabric.client;

import dev.architectury.event.events.client.ClientGuiEvent;
import dev.architectury.event.events.client.ClientPlayerEvent;
import dev.architectury.event.events.common.InteractionEvent;
import net.minecraft.class_1268;
import net.minecraft.class_1799;
import net.minecraft.class_239;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_746;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Opcodes;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Unique
@Mixin(class_310.class)
public abstract class MixinMinecraft {
    @Shadow
    @Nullable
    public class_746 player;
    
    @Shadow
    @Nullable
    public class_239 hitResult;
    
    @Shadow
    public abstract void setScreen(@Nullable class_437 screen);
    
    @Unique
    private ThreadLocal<Boolean> setScreenCancelled = new ThreadLocal<>();
    
    @Inject(method = "Lnet/minecraft/client/Minecraft;disconnect(Lnet/minecraft/client/gui/screens/Screen;ZZ)V",
            at = @At(value = "INVOKE", target = "Lnet/minecraft/client/GameNarrator;clear()V"))
    private void handleLogin(class_437 screen, boolean retainDownloadedPacks, boolean bl2, CallbackInfo ci) {
        ClientPlayerEvent.CLIENT_PLAYER_QUIT.invoker().quit(player);
    }
    
    @Inject(method = "startUseItem", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/item/ItemStack;isEmpty()Z", ordinal = 1),
            locals = LocalCapture.CAPTURE_FAILHARD)
    private void rightClickAir(CallbackInfo ci, class_1268[] var1, int var2, int var3, class_1268 interactionHand, class_1799 itemStack) {
        if (itemStack.method_7960() && (this.hitResult == null || this.hitResult.method_17783() == class_239.class_240.field_1333)) {
            InteractionEvent.CLIENT_RIGHT_CLICK_AIR.invoker().click(player, interactionHand);
        }
    }
    
    @Inject(method = "startAttack", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/player/LocalPlayer;resetAttackStrengthTicker()V", ordinal = 0))
    private void leftClickAir(CallbackInfoReturnable<Boolean> ci) {
        InteractionEvent.CLIENT_LEFT_CLICK_AIR.invoker().click(player, class_1268.field_5808);
    }
    
    @ModifyVariable(
            method = "setScreen",
            at = @At(value = "FIELD",
                    opcode = Opcodes.PUTFIELD,
                    target = "Lnet/minecraft/client/Minecraft;screen:Lnet/minecraft/client/gui/screens/Screen;",
                    shift = At.Shift.BY,
                    by = -1),
            argsOnly = true
    )
    public class_437 modifyScreen(class_437 screen) {
        var old = screen;
        var event = ClientGuiEvent.SET_SCREEN.invoker().modifyScreen(screen);
        if (event.isPresent()) {
            if (event.isFalse()) {
                setScreenCancelled.set(true);
                return old;
            } else {
                screen = event.object();
                if (old != null && screen != old) {
                    old.method_25432();
                }
            }
        }
        setScreenCancelled.set(false);
        return screen;
    }
    
    @Inject(
            method = "setScreen",
            at = @At(value = "FIELD",
                    opcode = Opcodes.PUTFIELD,
                    target = "Lnet/minecraft/client/Minecraft;screen:Lnet/minecraft/client/gui/screens/Screen;",
                    shift = At.Shift.BY,
                    by = -1),
            cancellable = true
    )
    public void cancelSetScreen(@Nullable class_437 screen, CallbackInfo ci) {
        if (setScreenCancelled.get()) {
            ci.cancel();
            setScreenCancelled.set(false);
        }
    }
}
