/*
 * This file is part of architectury.
 * Copyright (C) 2020, 2021, 2022 architectury
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

package dev.architectury.mixin.fabric;

import com.llamalad7.mixinextras.sugar.Local;
import dev.architectury.event.events.common.ChunkEvent;
import net.minecraft.class_1923;
import net.minecraft.class_2791;
import net.minecraft.class_2839;
import net.minecraft.class_2852;
import net.minecraft.class_3218;
import net.minecraft.class_4153;
import net.minecraft.class_9240;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_2852.class)
public class MixinSerializableChunkData {
    @Inject(method = "read", at = @At("RETURN"))
    private void load(class_3218 serverLevel, class_4153 poiManager, class_9240 regionStorageInfo, class_1923 chunkPos,
                      CallbackInfoReturnable<class_2839> cir,
                      @Local class_2791 chunkAccess) {
        ChunkEvent.LOAD_DATA.invoker().load(chunkAccess, serverLevel, (class_2852) (Object) this);
    }
}
