/*
 * This file is part of architectury.
 * Copyright (C) 2020, 2021, 2022 architectury
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

package dev.architectury.mixin.fabric;

import dev.architectury.event.events.common.PlayerEvent;
import net.minecraft.class_1297;
import net.minecraft.class_2535;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.class_8792;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_3324.class)
public class MixinPlayerList {
    @Inject(method = "placeNewPlayer", at = @At("RETURN"))
    private void placeNewPlayer(class_2535 connection, class_3222 serverPlayer, class_8792 commonListenerCookie, CallbackInfo ci) {
        PlayerEvent.PLAYER_JOIN.invoker().join(serverPlayer);
    }
    
    @Inject(method = "remove", at = @At("HEAD"))
    private void remove(class_3222 serverPlayer, CallbackInfo ci) {
        PlayerEvent.PLAYER_QUIT.invoker().quit(serverPlayer);
    }
    
    @Inject(method = "respawn", at = @At("RETURN"))
    private void respawn(class_3222 serverPlayer, boolean bl, class_1297.class_5529 removalReason, CallbackInfoReturnable<class_3222> cir) {
        PlayerEvent.PLAYER_RESPAWN.invoker().respawn(cir.getReturnValue(), bl, removalReason);
    }
}
