/*
 * This file is part of architectury.
 * Copyright (C) 2020, 2021, 2022 architectury
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

package dev.architectury.mixin.fabric;

import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.EntityEvent;
import net.minecraft.class_1308;
import net.minecraft.class_1936;
import net.minecraft.class_1948;
import net.minecraft.class_3218;
import net.minecraft.class_3730;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(class_1948.class)
public abstract class MixinNaturalSpawner {
    @Shadow
    private static boolean isValidPositionForMob(class_3218 serverLevel, class_1308 mob, double d) {
        return false;
    }
    
    @Redirect(
            method = "spawnCategoryForPosition(Lnet/minecraft/world/entity/MobCategory;Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/level/chunk/ChunkAccess;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/NaturalSpawner$SpawnPredicate;Lnet/minecraft/world/level/NaturalSpawner$AfterSpawnCallback;)V",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/level/NaturalSpawner;isValidPositionForMob(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/entity/Mob;D)Z",
                    ordinal = 0
            )
    )
    private static boolean overrideNaturalSpawnCondition(class_3218 level, class_1308 entity, double f) {
        var result = EntityEvent.LIVING_CHECK_SPAWN.invoker().canSpawn(entity, level, entity.field_6038, entity.field_5971, entity.field_5989, class_3730.field_16459, null);
        if (result.value() != null) {
            return result.value();
        } else {
            return isValidPositionForMob(level, entity, f);
        }
    }
    
    @Redirect(
            method = "spawnMobsForChunkGeneration",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/entity/Mob;checkSpawnRules(Lnet/minecraft/world/level/LevelAccessor;Lnet/minecraft/world/entity/EntitySpawnReason;)Z",
                    ordinal = 0
            )
    )
    private static boolean overrideChunkGenSpawnCondition(class_1308 mob, class_1936 level, class_3730 reason) {
        var result = EntityEvent.LIVING_CHECK_SPAWN.invoker().canSpawn(mob, level, mob.field_6038, mob.field_5971, mob.field_5989, reason, null);
        if (result.value() != null) {
            return result.value();
        } else {
            return mob.method_5979(level, reason);
        }
    }
    
}
