/*
 * This file is part of architectury.
 * Copyright (C) 2020, 2021, 2022 architectury
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

package dev.architectury.core.fluid.fabric;

import dev.architectury.core.fluid.ArchitecturyFluidAttributes;
import dev.architectury.fluid.FluidStack;
import dev.architectury.hooks.fluid.fabric.FluidStackHooksFabric;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.render.fluid.v1.FluidRenderHandler;
import net.fabricmc.fabric.api.transfer.v1.client.fluid.FluidVariantRenderHandler;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_3610;
import org.jetbrains.annotations.Nullable;

@Environment(EnvType.CLIENT)
class ArchitecturyFluidRenderingFabric implements FluidVariantRenderHandler, FluidRenderHandler {
    private final ArchitecturyFluidAttributes attributes;
    private class_1059 atlas = null;
    private final class_1058[] sprites = new class_1058[2];
    private final class_1058[] spritesOverlaid = new class_1058[3];
    private final class_1058[] spritesOther = new class_1058[2];
    private final class_1058[] spritesOtherOverlaid = new class_1058[3];
    
    public ArchitecturyFluidRenderingFabric(ArchitecturyFluidAttributes attributes) {
        this.attributes = attributes;
    }
    
    @Override
    @Nullable
    public class_1058[] getSprites(FluidVariant variant) {
        FluidStack stack = FluidStackHooksFabric.fromFabric(variant, FluidStack.bucketAmount());
        class_2960 overlayTexture = attributes.getOverlayTexture(stack);
        class_1058 overlaySprite = overlayTexture == null ? null : atlas.method_4608(overlayTexture);
        class_1058[] sprites = overlaySprite == null ? this.sprites : spritesOverlaid;
        sprites[0] = atlas.method_4608(attributes.getSourceTexture(stack));
        sprites[1] = atlas.method_4608(attributes.getFlowingTexture(stack));
        if (overlaySprite != null) sprites[2] = overlaySprite;
        return sprites;
    }
    
    @Override
    public int getColor(FluidVariant variant, @Nullable class_1920 view, @Nullable class_2338 pos) {
        return attributes.getColor(FluidStackHooksFabric.fromFabric(variant, FluidStack.bucketAmount()), view, pos);
    }
    
    @Override
    public class_1058[] getFluidSprites(@Nullable class_1920 view, @Nullable class_2338 pos, class_3610 state) {
        class_2960 overlayTexture = attributes.getOverlayTexture(state, view, pos);
        class_1058 overlaySprite = overlayTexture == null ? null : atlas.method_4608(overlayTexture);
        class_1058[] sprites = overlaySprite == null ? this.spritesOther : spritesOtherOverlaid;
        sprites[0] = atlas.method_4608(attributes.getSourceTexture(state, view, pos));
        sprites[1] = atlas.method_4608(attributes.getFlowingTexture(state, view, pos));
        if (overlaySprite != null) sprites[2] = overlaySprite;
        return sprites;
    }
    
    @Override
    public int getFluidColor(@Nullable class_1920 view, @Nullable class_2338 pos, class_3610 state) {
        return attributes.getColor(state, view, pos);
    }
    
    @Override
    public void reloadTextures(class_1059 atlas) {
        this.atlas = atlas;
    }
}
