/*
 * This file is part of architectury.
 * Copyright (C) 2020, 2021, 2022 architectury
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

package dev.architectury.mixin.fabric;

import dev.architectury.event.events.common.PlayerEvent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.OptionalInt;
import net.minecraft.class_1263;
import net.minecraft.class_1496;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3908;

@Mixin(class_3222.class)
public class MixinServerPlayer {
    @Inject(method = "restoreFrom", at = @At("RETURN"))
    private void restoreFrom(class_3222 serverPlayer, boolean bl, CallbackInfo ci) {
        PlayerEvent.PLAYER_CLONE.invoker().clone(serverPlayer, (class_3222) (Object) this, bl);
    }
    
    @Inject(method = "openMenu", at = @At("RETURN"))
    private void openMenu(class_3908 menuProvider, CallbackInfoReturnable<OptionalInt> cir) {
        if (cir.getReturnValue().isPresent()) {
            PlayerEvent.OPEN_MENU.invoker().open((class_3222) (Object) this, ((class_3222) (Object) this).field_7512);
        }
    }
    
    @Inject(method = "openHorseInventory", at = @At("RETURN"))
    private void openHorseInventory(class_1496 abstractHorse, class_1263 container, CallbackInfo ci) {
        PlayerEvent.OPEN_MENU.invoker().open((class_3222) (Object) this, ((class_3222) (Object) this).field_7512);
    }
    
    @Inject(method = "doCloseContainer",
            at = @At(value = "INVOKE", target = "Lnet/minecraft/world/inventory/AbstractContainerMenu;removed(Lnet/minecraft/world/entity/player/Player;)V",
                    shift = At.Shift.AFTER))
    private void doCloseContainer(CallbackInfo ci) {
        PlayerEvent.CLOSE_MENU.invoker().close((class_3222) (Object) this, ((class_3222) (Object) this).field_7512);
    }
    
    @Inject(method = "triggerDimensionChangeTriggers", at = @At("HEAD"))
    private void changeDimension(class_3218 serverLevel, CallbackInfo ci) {
        PlayerEvent.CHANGE_DIMENSION.invoker().change((class_3222) (Object) this, serverLevel.method_27983(), ((class_3222) (Object) this).method_51469().method_27983());
    }
    
    @Inject(method = "drop(Lnet/minecraft/world/item/ItemStack;ZZ)Lnet/minecraft/world/entity/item/ItemEntity;", at = @At("RETURN"), cancellable = true)
    private void dropItem(class_1799 itemStack, boolean bl, boolean bl2, CallbackInfoReturnable<class_1542> cir) {
        if (cir.getReturnValue() != null && PlayerEvent.DROP_ITEM.invoker().drop((class_3222) (Object) this, cir.getReturnValue()).isFalse()) {
            cir.setReturnValue(null);
        }
    }
}
