/*
 * This file is part of architectury.
 * Copyright (C) 2020, 2021, 2022 architectury
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

package dev.architectury.registry.fabric;

import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import dev.architectury.registry.CreativeTabOutput;
import dev.architectury.registry.CreativeTabRegistry;
import dev.architectury.registry.registries.DeferredSupplier;
import net.fabricmc.fabric.api.itemgroup.v1.FabricItemGroup;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.minecraft.class_1761;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class CreativeTabRegistryImpl {
    private static final Multimap<class_2960, Supplier<class_1799>> APPENDS = MultimapBuilder.hashKeys().arrayListValues().build();
    
    @ApiStatus.Experimental
    public static class_1761 create(Consumer<class_1761.class_7913> callback) {
        class_1761.class_7913 builder = FabricItemGroup.builder();
        callback.accept(builder);
        return builder.method_47324();
    }
    
    @ApiStatus.Experimental
    public static DeferredSupplier<class_1761> ofBuiltin(class_1761 tab) {
        class_2960 key = class_7923.field_44687.method_10221(tab);
        if (key == null) {
            throw new IllegalArgumentException("Builtin tab %s is not registered!".formatted(tab));
        }
        return new DeferredSupplier<>() {
            @Override
            public class_2960 getRegistryId() {
                return class_7924.field_44688.method_29177();
            }
            
            @Override
            public class_2960 getId() {
                return class_7923.field_44687.method_10221(tab);
            }
            
            @Override
            public boolean isPresent() {
                return true;
            }
            
            @Override
            public class_1761 get() {
                return tab;
            }
        };
    }
    
    @ApiStatus.Experimental
    public static DeferredSupplier<class_1761> defer(class_2960 name) {
        return new DeferredSupplier<>() {
            @Nullable
            private class_1761 tab;
            
            @Override
            public class_2960 getRegistryId() {
                return class_7924.field_44688.method_29177();
            }
            
            @Override
            public class_2960 getId() {
                return name;
            }
            
            @Override
            public class_1761 get() {
                resolve();
                if (tab == null)
                    throw new IllegalStateException("Creative tab %s was not registered yet!".formatted(name));
                return tab;
            }
            
            @Override
            public boolean isPresent() {
                resolve();
                return tab != null;
            }
            
            private void resolve() {
                if (this.tab == null) {
                    this.tab = class_7923.field_44687.method_63535(name);
                }
            }
        };
    }
    
    static {
        ItemGroupEvents.MODIFY_ENTRIES_ALL.register((tab, output) -> {
            APPENDS.get(class_7923.field_44687.method_10221(tab)).forEach(s -> output.method_45420(s.get()));
        });
    }
    
    public static void modify(DeferredSupplier<class_1761> tab, CreativeTabRegistry.ModifyTabCallback filler) {
        ItemGroupEvents.modifyEntriesEvent(tab.getKey()).register(entries -> {
            filler.accept(entries.getEnabledFeatures(), new CreativeTabOutput() {
                @Override
                public void acceptAfter(class_1799 after, class_1799 stack, class_1761.class_7705 visibility) {
                    if (after.method_7960()) {
                        entries.method_45417(stack, visibility);
                    } else {
                        entries.addAfter(after, List.of(stack), visibility);
                    }
                }
                
                @Override
                public void acceptBefore(class_1799 before, class_1799 stack, class_1761.class_7705 visibility) {
                    if (before.method_7960()) {
                        entries.method_45417(stack, visibility);
                    } else {
                        entries.addBefore(before, List.of(stack), visibility);
                    }
                }
            }, entries.shouldShowOpRestrictedItems());
        });
    }
    
    @ApiStatus.Experimental
    public static void appendStack(DeferredSupplier<class_1761> tab, Supplier<class_1799> item) {
        APPENDS.put(tab.getId(), item);
    }
}
