/*
 * This file is part of architectury.
 * Copyright (C) 2020, 2021, 2022 architectury
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

package dev.architectury.mixin.fabric.client;

import dev.architectury.event.events.client.ClientGuiEvent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.List;
import net.minecraft.class_332;
import net.minecraft.class_340;

@Mixin(class_340.class)
public class MixinDebugScreenOverlay {
    @Inject(method = "renderLines", at = @At("RETURN"))
    private void getLeftTexts(class_332 guiGraphics, List<String> list, boolean bl, CallbackInfo ci) {
        if (bl) {
            ClientGuiEvent.DEBUG_TEXT_LEFT.invoker().gatherText(list);
        } else {
            ClientGuiEvent.DEBUG_TEXT_RIGHT.invoker().gatherText(list);
        }
    }
}
