/*
 * This file is part of architectury.
 * Copyright (C) 2020, 2021, 2022 architectury
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

package dev.architectury.mixin.fabric.client;

import dev.architectury.event.EventResult;
import dev.architectury.event.events.client.ClientChatEvent;
import dev.architectury.event.events.client.ClientPlayerEvent;
import dev.architectury.event.events.client.ClientRecipeUpdateEvent;
import net.minecraft.class_10266;
import net.minecraft.class_10268;
import net.minecraft.class_10286;
import net.minecraft.class_2535;
import net.minecraft.class_2678;
import net.minecraft.class_2724;
import net.minecraft.class_2788;
import net.minecraft.class_310;
import net.minecraft.class_634;
import net.minecraft.class_638;
import net.minecraft.class_746;
import net.minecraft.class_8673;
import net.minecraft.class_8675;
import net.minecraft.network.protocol.game.*;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_634.class)
public abstract class MixinClientPacketListener extends class_8673 {
    @Shadow
    private class_638 level;
    
    @Shadow
    public abstract class_10286 recipes();
    
    @Unique
    private class_746 tmpPlayer;
    
    protected MixinClientPacketListener(class_310 minecraft, class_2535 connection, class_8675 commonListenerCookie) {
        super(minecraft, connection, commonListenerCookie);
    }
    
    @Inject(method = "handleLogin", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/Options;setServerRenderDistance(I)V", shift = At.Shift.AFTER))
    private void handleLogin(class_2678 packet, CallbackInfo ci) {
        ClientPlayerEvent.CLIENT_PLAYER_JOIN.invoker().join(field_45588.field_1724);
    }
    
    @Inject(method = "handleRespawn", at = @At("HEAD"))
    private void handleRespawnPre(class_2724 packet, CallbackInfo ci) {
        this.tmpPlayer = field_45588.field_1724;
    }
    
    @Inject(method = "handleRespawn", at = @At(value = "INVOKE",
            target = "Lnet/minecraft/client/multiplayer/ClientLevel;addEntity(Lnet/minecraft/world/entity/Entity;)V"))
    private void handleRespawn(class_2724 packet, CallbackInfo ci) {
        ClientPlayerEvent.CLIENT_PLAYER_RESPAWN.invoker().respawn(tmpPlayer, field_45588.field_1724);
        this.tmpPlayer = null;
    }
    
    @Inject(method = "handleUpdateRecipes", at = @At("RETURN"))
    private void handleUpdateRecipes(class_2788 clientboundUpdateRecipesPacket, CallbackInfo ci) {
        ClientRecipeUpdateEvent.EVENT.invoker().update(recipes());
    }
    
    @Inject(method = "handleRecipeBookAdd", at = @At("RETURN"))
    private void handleRecipeBookAdd(class_10266 packet, CallbackInfo ci) {
        ClientRecipeUpdateEvent.ADD.invoker().add(recipes(), packet.comp_3232());
    }
    
    @Inject(method = "handleRecipeBookRemove", at = @At("RETURN"))
    private void handleRecipeBookRemove(class_10268 packet, CallbackInfo ci) {
        ClientRecipeUpdateEvent.REMOVE.invoker().remove(recipes(), packet.comp_3235());
    }
    
    @Inject(method = "sendChat(Ljava/lang/String;)V", at = @At(value = "HEAD"), cancellable = true)
    private void chat(String string, CallbackInfo ci) {
        EventResult process = ClientChatEvent.SEND.invoker().send(string, null);
        if (process.isFalse()) {
            ci.cancel();
        }
    }
}
