/*
 * This file is part of architectury.
 * Copyright (C) 2020, 2021, 2022 architectury
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

package dev.architectury.mixin.fabric.client;

import com.mojang.authlib.GameProfile;
import dev.architectury.event.CompoundEventResult;
import dev.architectury.event.events.client.ClientChatEvent;
import dev.architectury.event.events.client.ClientSystemMessageEvent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

import java.util.Objects;
import net.minecraft.class_2556;
import net.minecraft.class_2561;
import net.minecraft.class_7471;
import net.minecraft.class_7594;

@Mixin(class_7594.class)
public class MixinChatListener {
    @Unique
    class_2556.class_7602 boundChatType;
    @Unique
    private ThreadLocal<class_2561> cancelNextChat = new ThreadLocal<>();
    @Unique
    private ThreadLocal<class_2561> cancelNextSystem = new ThreadLocal<>();
    
    @Inject(method = "handlePlayerChatMessage", at = @At(value = "INVOKE", target = "Ljava/time/Instant;now()Ljava/time/Instant;"))
    private void handlePlayerChatMessage(class_7471 playerChatMessage, GameProfile gameProfile, class_2556.class_7602 bound, CallbackInfo ci) {
        this.boundChatType = bound;
    }
    
    @ModifyVariable(method = "handlePlayerChatMessage", at = @At(value = "INVOKE", target = "Lnet/minecraft/network/chat/PlayerChatMessage;signature()Lnet/minecraft/network/chat/MessageSignature;"))
    private class_2561 modifyMessage(class_2561 value) {
        cancelNextChat.remove();
        var process = ClientChatEvent.RECEIVED.invoker().process(boundChatType, value);
        this.boundChatType = null;
        if (process.isPresent()) {
            if (process.isFalse()) {
                cancelNextChat.set(value);
            } else if (process.object() != null) {
                return process.object();
            }
        }
        
        return value;
    }
    
    @Inject(method = "handlePlayerChatMessage", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/multiplayer/chat/ChatListener;handleMessage(Lnet/minecraft/network/chat/MessageSignature;Ljava/util/function/BooleanSupplier;)V"),
            cancellable = true, locals = LocalCapture.CAPTURE_FAILHARD)
    private void handleChatPre(class_7471 playerChatMessage, GameProfile gameProfile, class_2556.class_7602 bound, CallbackInfo ci, boolean onlyShowSecureChat, class_7471 filtered, class_2561 component) {
        if (Objects.equals(cancelNextChat.get(), component)) {
            ci.cancel();
        }
        
        cancelNextChat.remove();
    }
    
    @ModifyVariable(method = "handleSystemMessage", at = @At(value = "HEAD"), argsOnly = true)
    private class_2561 modifySystemMessage(class_2561 message) {
        cancelNextSystem.remove();
        var process = ClientSystemMessageEvent.RECEIVED.invoker().process(message);
        if (process.isPresent()) {
            if (process.isFalse()) {
                cancelNextSystem.set(message);
            } else if (process.object() != null) {
                return process.object();
            }
        }
        return message;
    }
    
    @Inject(method = "handleSystemMessage", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/Options;hideMatchedNames()Lnet/minecraft/client/OptionInstance;"),
            cancellable = true)
    private void handleSystemMessage(class_2561 component, boolean bl, CallbackInfo ci) {
        if (Objects.equals(cancelNextSystem.get(), component)) {
            ci.cancel();
        }
        
        cancelNextSystem.remove();
    }
}
