/*
 * This file is part of architectury.
 * Copyright (C) 2020, 2021, 2022 architectury
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

package dev.architectury.fluid.fabric;

import I;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.architectury.fluid.FluidStack;
import io.netty.buffer.ByteBuf;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.minecraft.class_3609;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9323;
import net.minecraft.class_9326;
import net.minecraft.class_9331;
import net.minecraft.class_9335;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;

@ApiStatus.Internal
public enum FluidStackImpl implements FluidStack.FluidStackAdapter<FluidStackImpl.Pair> {
    INSTANCE;
    
    static {
        dev.architectury.fluid.FluidStack.init();
    }
    
    public static Function<FluidStack, Object> toValue;
    public static Function<Object, FluidStack> fromValue;
    
    public static FluidStack.FluidStackAdapter<Object> adapt(Function<FluidStack, Object> toValue, Function<Object, dev.architectury.fluid.FluidStack> fromValue) {
        FluidStackImpl.toValue = toValue;
        FluidStackImpl.fromValue = fromValue;
        return (FluidStack.FluidStackAdapter<Object>) (FluidStack.FluidStackAdapter<?>) INSTANCE;
    }
    
    public static class Pair {
        public class_3611 fluid;
        public class_9335 components;
        public long amount;
        
        public Pair(class_3611 fluid, @Nullable class_9326 patch, long amount) {
            this(fluid,
                    patch == null ? new class_9335(class_9323.field_49584)
                            : class_9335.method_57935(class_9323.field_49584, patch),
                    amount);
        }
        
        public Pair(class_3611 fluid, class_9335 components, long amount) {
            this.fluid = fluid;
            this.components = components;
            this.amount = amount;
        }
        
        public FluidVariant toVariant() {
            return FluidVariant.of(fluid, getPatch());
        }
        
        public class_9326 getPatch() {
            return amount <= 0L || this.fluid == class_3612.field_15906 ? components.method_57940() : class_9326.field_49588;
        }
    }
    
    @Override
    public FluidStackImpl.Pair create(Supplier<class_3611> fluid, long amount, @Nullable class_9326 patch) {
        class_3611 fluidType = Objects.requireNonNull(fluid).get();
        if (fluidType instanceof class_3609 flowingFluid) {
            fluidType = flowingFluid.method_15751();
        }
        return new Pair(fluidType, patch, amount);
    }
    
    @Override
    public Supplier<class_3611> getRawFluidSupplier(FluidStackImpl.Pair object) {
        return () -> object.fluid;
    }
    
    @Override
    public class_3611 getFluid(FluidStackImpl.Pair object) {
        return object.fluid;
    }
    
    @Override
    public long getAmount(FluidStackImpl.Pair object) {
        return object.amount;
    }
    
    @Override
    public void setAmount(FluidStackImpl.Pair object, long amount) {
        object.amount = amount;
    }
    
    public class_9326 getPatch(FluidStackImpl.Pair value) {
        return value.getPatch();
    }
    
    @Override
    public class_9335 getComponents(Pair value) {
        return value.components;
    }
    
    @Override
    public void applyComponents(Pair value, class_9326 patch) {
        value.components.method_57936(patch);
    }
    
    @Override
    public void applyComponents(Pair value, class_9323 patch) {
        value.components.method_57933(patch);
    }
    
    @Override
    @Nullable
    public <D> D set(Pair value, class_9331<D> type, @Nullable D component) {
        return value.components.method_57938(type, component);
    }
    
    @Override
    @Nullable
    public <D> D remove(Pair value, class_9331<? extends D> type) {
        return value.components.method_57939(type);
    }
    
    @Override
    @Nullable
    public <D> D update(Pair value, class_9331<D> type, D component, UnaryOperator<D> updater) {
        return value.components.method_57938(type, updater.apply(getComponents(value).method_58695(type, component)));
    }
    
    @Override
    @Nullable
    public <D, U> D update(Pair value, class_9331<D> type, D component, U updateContext, BiFunction<D, U, D> updater) {
        return value.components.method_57938(type, updater.apply(getComponents(value).method_58695(type, component), updateContext));
    }
    
    @Override
    public FluidStackImpl.Pair copy(FluidStackImpl.Pair value) {
        return new Pair(value.fluid, value.components.method_57941(), value.amount);
    }
    
    @Override
    public int hashCode(FluidStackImpl.Pair value) {
        var pair = (Pair) value;
        var code = 1;
        code = 31 * code + pair.fluid.hashCode();
        code = 31 * code + Long.hashCode(pair.amount);
        code = 31 * code + pair.components.hashCode();
        return code;
    }
    
    @Override
    public Codec<FluidStack> codec() {
        return RecordCodecBuilder.create(instance -> instance.group(
                class_7923.field_41173.method_40294().fieldOf("fluid").forGetter(stack -> stack.getFluid().method_40178()),
                Codec.LONG.validate(value -> {
                    return value.compareTo(0L) >= 0 && value.compareTo(Long.MAX_VALUE) <= 0
                            ? DataResult.success(value)
                            : DataResult.error(() -> "Value must be non-negative: " + value);
                }).fieldOf("amount").forGetter(FluidStack::getAmount),
                class_9326.field_49589.optionalFieldOf("components", class_9326.field_49588).forGetter(FluidStack::getPatch)
        ).apply(instance, FluidStack::create));
    }
    
    @Override
    public class_9139<class_9129, FluidStack> streamCodec() {
        return class_9139.method_56436(class_9135.method_56383(class_7924.field_41270), stack -> stack.getFluid().method_40178(),
                class_9139.method_56437(ByteBuf::writeLong, ByteBuf::readLong), FluidStack::getAmount,
                class_9326.field_49590, FluidStack::getPatch,
                FluidStack::create);
    }
}
